unit FormOsoby;

interface

uses
  Windows, Messages, Classes, SysUtils, Graphics, Controls, StdCtrls, Forms,
  Dialogs, DBCtrls, DB, DBGrids, Grids, ExtCtrls, ActnList, Buttons, Variants,
  DBTables,
  {}
  DataModule;


type
  TFOsoby = class(TForm)
    DBGrid1: TDBGrid;
    Panel1: TPanel;
    Panel2: TPanel;
    btnClose: TSpeedButton;
    btnFind1: TBitBtn;
    btnFind2: TBitBtn;
    btnLocate: TBitBtn;
    btnFilter: TBitBtn;
    procedure FormShow(Sender: TObject);
    procedure btnFilterClick(Sender: TObject);
    procedure btnLocateClick(Sender: TObject);
    procedure btnFind2Click(Sender: TObject);
    procedure btnFind1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormDestroy(Sender: TObject);
    procedure ActionCloseExecute(Sender: TObject);
    procedure DBGrid1KeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
  private
    filtr : String;

  public
    procedure  My_Close();
    procedure  My_filter();
    procedure  My_find1();
    procedure  My_find2();
    procedure  My_Locate();
  end;

var
  FOsoby: TFOsoby;

implementation
{$R *.DFM}
{------------------------------------------------------------------------------}
procedure TFOsoby.ActionCloseExecute(Sender: TObject);
begin
   My_Close();
end;

procedure TFOsoby.My_Close();
begin
	Close();
end;

procedure TFOsoby.btnFilterClick(Sender: TObject);
begin
   My_filter();
end;

procedure TFOsoby.My_filter();
var
   nazwisko : String;

begin
   nazwisko := '';
   nazwisko := InputBox('Filter - Wybr osb', 'Podaj nazwisko', '');

   if nazwisko <> '' then
   begin
		DM.TableOsoby.IndexName := '';
		DM.TableOsoby.Filtered  := False;
      DM.set_filtr(nazwisko);
      DM.TableOsoby.Filtered := True;
   end
   else begin
      DM.TableOsoby.Filtered := False;
   end;
end;

procedure TFOsoby.btnFind1Click(Sender: TObject);
begin
   My_find1();
end;

procedure TFOsoby.My_Find1();
var
	nazwisko : String;
	znalazl  : Boolean;

begin
   nazwisko := InputBox('Find1 - Wybr osoby', 'Podaj nazwisko', '');

   DM.TableOsoby.Close();
   DM.TableOsoby.IndexName := 'OSOBY_NAZWISKO';
   DM.TableOsoby.Open();
   DM.TableOsoby.First();

   if nazwisko <> '' then
   begin
      znalazl := false;
      znalazl := DM.TableOsoby.FindKey([nazwisko]);

      if not znalazl then
   	begin
         ShowMessage('Find1 - Osoba: ' + nazwisko + ' nie odnaleziona');
      end;
   end;
end;

procedure TFOsoby.btnFind2Click(Sender: TObject);
begin
   My_find2();
end;

procedure TFOsoby.My_Find2();
var
	nazwisko : String;
	imie     : String;
	znalazl  : Boolean;

begin
   nazwisko := '';
   imie     := '';
	znalazl  := false;

   DM.TableOsoby.Close();
   DM.TableOsoby.IndexName := 'OSOBY_NAZWISKO_IMIE';
   DM.TableOsoby.Open();
   DM.TableOsoby.First();

   nazwisko := InputBox('Find2 - Wybr osoby', 'Podaj nazwisko', '');

   if nazwisko <> '' then
	begin
      imie := InputBox('Find 2 - Wybr osoby', 'Podaj imi', '');
      if imie <> '' then
   	begin
	      znalazl := DM.TableOsoby.FindKey([nazwisko, imie]);

         if not znalazl then
      	begin
            ShowMessage('Find2 - Osoba: ' + nazwisko + ' nie odnaleziona');
         end;
      end;
   end;
end;

procedure TFOsoby.btnLocateClick(Sender: TObject);
begin
   My_Locate();
end;

procedure TFOsoby.My_Locate();
var
	nazwisko : String;
	imie     : String;
	znalazl  : Boolean;

begin
   nazwisko := '';
   imie     := '';
	znalazl  := false;

   nazwisko := InputBox('Locate Wybr osoby', 'Podaj nazwisko', '');
   if nazwisko = '' then
	begin
   	exit;
   end;

	imie := InputBox('Locate Wybr osoby', 'Podaj imi', '');
   if imie = '' then
	begin
		exit;
   end;

	znalazl := DM.TableOsoby.Locate('nazwisko;imie', VarArrayOf([nazwisko, imie]), [loCaseInsensitive]);

   if not znalazl then
	begin
      ShowMessage('Locate Osoba: ' + nazwisko + ' ' + imie + '\n' + 'nie odnaleziona');
   end;
end;

procedure TFOsoby.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   Action := caFree;
end;

procedure TFOsoby.FormDestroy(Sender: TObject);
begin
   FOsoby := NIL;
end;

procedure TFOsoby.FormShow(Sender: TObject);
begin
   Left  := 0;
   Width := Screen.Width;
end;

procedure TFOsoby.DBGrid1KeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
   if key = VK_F7 then begin
      My_filter();
   end;

   if key = VK_F8 then begin
      My_find1();
   end;
end;

end.

